/*---------------------------------------------------------------------------+
| PMSPY - Message Filter Dialog Procedure
|
| Change History:
| ---------------
| $C1=1.01,06/14/89,smd,'highlight' CHECKBOX in FILTER dialog
| $C2=1.03,06/19/89,smd,HELP pushbutton
|
+---------------------------------------------------------------------------*/

#include "pmspy.h"

static HELP_DATA    helpFilter    = {                  /* @C5A - HELP dialog data */
                                      { NULL,
                                        IDT_HELP,
                                        IDT_F_HELP,    /* HELP resource */
                                      },

                                      IDS_HELP_TITLE_SELECTIVE
                                    };

/******************************************************************************
*
* SetColors
*
* - common subroutine to 'set up' the Color listbox in various dialogs
*
******************************************************************************/

VOID SetColors( HWND hwnd )

{
 register USHORT i;

 /* Add all colors to the list in 'asis' order */

 for( /* Initialize */  i = 0;              /* start @ first */
      /* Terminate  */  i < Color_Total;    /* stop at End-Of-Table */
      /* Iterate    */  i++                 /* try the next */
    )
 {
   WinSendDlgItemMsg(hwnd,                           /* Window Handle  */
                     ID_LB_COLORS,                   /* Listbox ID     */
                     LM_INSERTITEM,                  /* Insert item    */
                     (MPARAM) LIT_END,               /* At the End     */
                     (MPARAM) ExternalColorTranslation[pSpyData->LogicalColorTranslation[i].iExtColor].pszClrName);
 }
}

/******************************************************************************
*
* GetColor
*
* - common subroutine to 'get the value' of the Color
*   selected by the user from the color LISTBOX
*
******************************************************************************/

MSG_COLOR GetColor( HWND hwnd )

{
  register  USHORT     curItem;                     /* current list item */

  return( (curItem = (USHORT)WinSendDlgItemMsg(hwnd,               /* Dialog handle        */
                                               ID_LB_COLORS,       /* Listbox ID           */
                                               LM_QUERYSELECTION,  /* Query ID of selected */
                                               (MPARAM)LIT_FIRST,
                                               (MPARAM)NULL)) == LIT_NONE

          ? Color_Asis                     /* none selected, so leave ASIS */
          : pSpyData->LogicalColorTranslation[curItem].pbValue
        );
}

 /***************************************************************************************
  *
  *                       Entry
  *
  ***************************************************************************************/

 MRESULT EXPENTRY FilterDlgProc(          HWND    hwnd,
                                 register USHORT  message,
                                          MPARAM  lParam1,
                                          MPARAM  lParam2 )

  {

   /***********************************************************************************
    *
    *                   Local Variables
    *
    ***********************************************************************************/

     ULONG              retcode;
     register USHORT    pbSelected;
     CHAR               sFilterItem[100];

 /***************************************************************************************
  *
  *  Process the message
  *
  ***************************************************************************************/

    switch (message)                                    /* Switch off of the message ID */
      {

        case WM_COMMAND:

          switch( pbSelected = LOUSHORT( lParam1 ) )
          {

              /**************************************************************************
               *
               *  Process items marked for exclusion/inclusion/deletion
               *
               **************************************************************************/

              case ID_PB_F_DELETE:
              case ID_PB_F_EXCLUDE:
              case ID_PB_F_INCLUDE:

              {
                PMSG_ITEM     pMsg;                                   /* Points to element in chain   */

                USHORT        curItem,                                /* current list item */
                              nSelected;                              /* Number of items selected     */

                MSG_COLOR     color = GetColor( hwnd );

                for(/* Initialize */ nSelected = 0,                    /* Zero out vars                */
                                     curItem   = (USHORT)
                                                 WinSendDlgItemMsg(    /* Query 1st selection          */
                                                 hwnd,                 /*   Dialog handle              */
                                                 IDD_FILTER,           /*   Listbox ID                 */
                                                 LM_QUERYSELECTION,    /*   Query ID of selected       */
                                                 (MPARAM)LIT_FIRST,
                                                 (MPARAM)NULL);

                    /* Terminate  */ curItem != LIT_NONE;

                    /* Iterate    */ nSelected++,
                                     curItem   = (USHORT)
                                                 WinSendDlgItemMsg(    /* Query next selection         */
                                                 hwnd,                 /*   Dialog handle              */
                                                 IDD_FILTER,           /*   Listbox ID                 */
                                                 LM_QUERYSELECTION,    /*   Query ID of selected       */
                                                 (MPARAM)curItem,
                                                 (MPARAM)NULL)
                   )
                {

                  pMsg = (PMSG_ITEM)
                         WinSendDlgItemMsg( hwnd,
                                            IDD_FILTER,
                                            LM_QUERYITEMHANDLE, /*   Message                    */
                                            (MPARAM) curItem,   /*   Item to get handle of      */
                                            (MPARAM) NULL);     /*   Reserved                   */

                  switch( pbSelected )
                  {
                    case ID_PB_F_DELETE:
                         DeleteMsg(pSpyData, pMsg->Msg);
                         break;

                    case ID_PB_F_EXCLUDE:
                         IncludeMsg(pSpyData, pMsg->Msg, FALSE, color);
                         break;

                    case ID_PB_F_INCLUDE:
                         IncludeMsg(pSpyData, pMsg->Msg, TRUE, color);
                         break;
                  }
                }

                if (nSelected == 0)  /* Selections? */
                {
                  WinAlarm(HWND_DESKTOP, WA_ERROR);

                  break;                                   /* DO NOT end dialog */
                }
              }
              /*********************************
              *** FALL THROUGH TO END DIALOG ***
              *********************************/

              /**************************************************************************
               *
               *  User cancelled exclusion/inclusion
               *
               **************************************************************************/

              case DID_CANCEL:                          /* CANCEL was selected          */

                  WinDismissDlg( hwnd,                  /* Close dialog */
                                 NULL );                /* WinDlgBox return */

                break;                                  /* Break DID_CANCEL             */

              /**************************************************************************
               *
               *  User asked for HELP
               *
               **************************************************************************/

              case ID_PB_F_HELP:                        /* @C2A */

                   WinDlgBox(HWND_DESKTOP, hwnd,        /* @C2A */
                            (PFNWP)HelpWindowProc,
                             NULL, IDD_HELP, (PVOID)&helpFilter);
                break;                                  /* @C2A */
          }

            retcode = NULL;                             /* retcode for any WM_COMMAND   */
            break;                                      /* Break WM_COMMAND             */

        /********************************************************************************/
        /**                                                                            **/
        /** WM_CLOSE:                                                                  **/
        /** - Call WinDismissDlg to close the dialog box                               **/
        /**                                                                            **/
        /********************************************************************************/

        case WM_CLOSE:                                  /* Close Dialog Box.            */

          WinDismissDlg( hwnd, NULL);

          retcode = TRUE;

          break;                                                                           /* DB  @P4A */

        /*******************************************************************************
         *
         *  WM_INITDLG:
         *  - Init pointer to data pointed to by WinDlgBox
         *  - Init global handle of this dlg
         *
         ********************************************************************************/

        case WM_INITDLG:
             {
               register PMSG_ITEM  pMsg;
               register USHORT     list_index;

              /******************************************************************************
               *
               *   Add all Messages to list box
               *
               ******************************************************************************/

               for( /* Initialize */  pMsg = ProcessFirstMsg(pSpyData); /* start @ first MSG */
                    /* Terminate  */  pMsg != NULL;                     /* stop at End-Of-Table */
                    /* Iterate    */  pMsg = ProcessNextMsg(pSpyData)   /* try the next MSG */
                  )
               {
                 sprintf(sFilterItem,
                         pMsg->Include ? Strings[IDS_FMT_MSG_INCLUDED]
                                       : Strings[IDS_FMT_MSG_EXCLUDED],
                         pMsg->pDesc,                     /* wording of Msg */
                         pMsg->Msg                        /* value   of Msg */
                        );

                 list_index = (USHORT) WinSendDlgItemMsg(      /* Send a message to the list   */
                               hwnd,                           /*   Window Handle              */
                               IDD_FILTER,
                               LM_INSERTITEM,                  /*   Insert item                */
                               (MPARAM) LIT_SORTASCENDING,     /*   Sort                       */
                               (MPARAM) sFilterItem);          /*   Text                       */

                 WinSendDlgItemMsg(                                    /* Send a message to the list   */
                               hwnd,                          /*   Window Handle              */
                               IDD_FILTER,
                               LM_SETITEMHANDLE,                       /*   Message                    */
                               (MPARAM)list_index,                     /*   Index of list item         */
                               (MPARAM)pMsg);                          /*   Handle of list item        */
               }

               SetColors( hwnd );

             }

          retcode = FALSE;
          break;                                        /* WM_INITDLG                   */

        default:                                        /* Any other message            */
          retcode =  (ULONG)WinDefDlgProc(              /* Return message to default prc*/
                        hwnd,                  /* Dialog Handle                */
                        message,                        /* Message                      */
                        lParam1,                        /* First parameter for message. */
                        lParam2);                       /* Second parameter for message.*/
      }                                                 /* End switch                   */

 /***************************************************************************************
  *
  *                       Exit
  *
  ***************************************************************************************/

   return((MRESULT) retcode);
}
